<?php


namespace Cms\Client\AddressBook;

use Cms\Client\AbstractClient;
use Cms\Client\AddressBook\Model\TripRestfulModel;
use Cms\Client\ClientFetchStrategy;
use Cms\Client\CmsApiIndexIterator;

/**
 * Class AddressBookTripClient
 * @package Cms\Client\AddressBook
 */
class AddressBookTripClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'addressbook/trip';

    /** @var string */
    protected $fetchStrategy = ClientFetchStrategy::FETCH_ASYNC;

    /**
     * @return AddressBookTripClientQueryBuilder
     */
    public function getBuilder()
    {
        $builder = new AddressBookTripClientQueryBuilder($this);
        return $builder;
    }

    /**
     * @param array $dataset
     * @return TripRestfulModel
     */
    public function handleData($dataset = [])
    {
        return (new TripRestfulModel())->populate($dataset ?: [], true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|TripRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param array|int $scopeId
     * @param string $search
     * @param int $pageNum
     * @return Model\TripRestfulModel[]|CmsApiIndexIterator
     */
    public function fetchAllBySearch($scopeId, $search, $pageNum = 0)
    {
        return $this->getBuilder()
            ->setSearch($search)
            ->setScope($scopeId)
            ->getIndex($pageNum);
    }

    /**
     * @param string $scope
     * @param string $slug
     * @return null|TripRestfulModel
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function fetchItemBySlug($scope, $slug)
    {
        $object = $this->fetchItem($slug, [
            'scope' => $scope,
        ]);
        return $object;
    }
}
