<?php


namespace Cms\Client\Article;

use Cms\Client\ClientIndexQueryBuilder;
use Cms\Model\Article\Category\CategoryProfil;
use Cms\Model\Article\Category\CategoryState;

/**
 * Class CategoryClientQueryBuilder
 * @package Cms\Client\Article
 */
class CategoryClientQueryBuilder extends ClientIndexQueryBuilder
{

    /**
     * @param int $parentId
     * @return CategoryClientQueryBuilder
     */
    public function setParentId($parentId)
    {
        return $this->setFilter('parent_id', $parentId);
    }

    /**
     * @param string|CategoryState $state
     * @return CategoryClientQueryBuilder
     */
    public function setState($state)
    {
        return $this->setFilter('state', $state);
    }

    /**
     * @param int $scope
     * @return CategoryClientQueryBuilder
     */
    public function setScope($scope)
    {
        return $this->setFilter('scope', $scope);
    }

    /**
     * @param CategoryProfil|string $profil
     * @return CategoryClientQueryBuilder
     */
    public function setProfil($profil)
    {
        return $this->setFilter('profil', $profil);
    }

    /**
     * @param string $search
     * @return CategoryClientQueryBuilder
     */
    public function setSearch($search)
    {
        return $this->setFilter('search', $search);
    }
}
