<?php


namespace Cms\Controller;

use Cms\Client\Article\CategoryClient;
use Cms\Client\Article\Model\CategoryRestfulModel;
use Cms\Model\I18nHelper;
use Move\Template\Component\BreadcrumpComponent;

/**
 * Class BreadcrumpControllerTrait
 * @package Cms\Controller
 */
trait BreadcrumpControllerTrait
{

    /**
     * @param CategoryRestfulModel $category
     * @return string
     */
    abstract protected function buildUrlForBreadcrump(CategoryRestfulModel $category) : string;

    /**
     * @param array|CategoryClient $categoryClient
     * @param int $categoryId
     * @return BreadcrumpComponent
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    protected function buildBreadcrumb(
        CategoryClient $categoryClient,
        $categoryId
    ) : BreadcrumpComponent {
        // ajoute dans le breadcrump la catégory parente
        $category = $categoryClient->fetchItem($categoryId);
        if ($category instanceof CategoryRestfulModel) {
            if (!empty($category->parent_id)) {
                $this->buildBreadcrumb($categoryClient, $category->parent_id);
            }
            return BreadcrumpComponent::GetInstance()->addElement(
                I18nHelper::translateObject($category, 'name'),
                $this->buildUrlForBreadcrump($category)
            );
        }
        throw new \InvalidArgumentException('category_id: ' . $categoryId);
    }
}
