<?php


namespace Cms\Model\Navigation;

use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class NavigationItemModel
 * @package Cms\Model\Navigation
 * @property int $id
 * @property int $parent_id
 * @property string $name
 * @property int $rank
 * @property string $url
 * @property NavigationItemTarget $target
 */
class NavigationItemModel extends DomainObjectAbstract
{
    use StampAwareModelTrait;
    use ScopeAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $parent_id;

    /** @var  string */
    protected $name;

    /** @var  int */
    protected $rank;

    /** @var  string */
    protected $url;

    /** @var  NavigationItemTarget */
    protected $target;
}
