<?php


namespace Cms\Model\Scheduler\Task;

use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class TaskModel
 * @package Cms\Model\Scheduler\Task
 * @property int $id
 * @property int $cms_user_id
 * @property string $name
 * @property string $referrer
 * @property int $retry
 * @property string|TaskPeriodicity $periodicity
 * @property TaskActionType $action_type
 * @property mixed $action_params
 * @property TaskState $state
 * @property \DateTime $execution_at
 */
class TaskModel extends DomainObjectAbstract
{
    use StampAwareModelTrait;
    use ScopeAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $cms_user_id;

    /** @var  string */
    protected $name;

    /** @var  int */
    protected $retry;

    /** @var  string */
    protected $periodicity;

    /** @var  string */
    protected $referrer;

    /** @var  TaskActionType */
    protected $action_type;

    /** @var  mixed */
    protected $action_params;

    /** @var  TaskState */
    protected $state;

    /** @var  \DateTime */
    protected $execution_at;
}
