<?php

namespace Move\Command\Command;

/**
 * Class FilterCommandTrait
 * @package Move\Command\Command
 */
trait FilterCommandTrait
{

    /** @var array */
    protected $filters = [];

    /**
     * @param array $filters
     * @return FilterCommandInterface
     */
    public function withFilters(array $filters) : FilterCommandInterface
    {
        $clone = clone $this;
        $clone->filters = $filters;
        return $clone;
    }

    /**
     * @param string $name
     * @param string|array $value
     * @return \Move\Command\Command\FilterCommandInterface
     * @throws \InvalidArgumentException
     */
    public function withFilterValue(string $name, $value) : FilterCommandInterface
    {
        $clone = clone $this;
        $clone->filters[$name] = $value;
        return $clone;
    }

    /**
     * @param string $name
     * @param string|array $value
     * @return \Move\Command\Command\FilterCommandInterface
     * @throws \InvalidArgumentException
     */
    public function withAddedFilter(string $name, $value) : FilterCommandInterface
    {
        $clone = clone $this;
        if (empty($clone->filters[$name])) {
            $clone->filters[$name] = [];
        } elseif (!\is_array($clone->filters[$name])) {
            $clone->filters[$name] = [$clone->filters[$name]];
        }
        $clone->filters[$name][] = $value;
        return $clone;
    }

    /**
     * @return array
     */
    public function getFilters() : array
    {
        return $this->filters;
    }

    /**
     * @param string $name
     * @return null|string|array
     */
    public function getFilterValue(string $name)
    {
        return $this->filters[$name] ?? null;
    }
}
