<?php


namespace Move\Embed\Normalizer;

use Move\Embed\Parser\ParserInterface;

/**
 * Class DigitekaNormalizer
 * @package Move\Embed\Normalizer
 */
class DigitekaNormalizer implements NormalizerInterface
{
    /** @var ParserInterface */
    private $parser;

    /** @var string */
    private $mdtk;

    /**
     * DigitekaNormalizer constructor.
     * @param ParserInterface $parser
     * @param string $mdtk
     */
    public function __construct(ParserInterface $parser, string $mdtk)
    {
        $this->parser = $parser;
        $this->mdtk = $mdtk;
    }

    /**
     * @param string $sourceUri
     * @return string
     * @throws \InvalidArgumentException
     */
    public function __invoke($sourceUri)
    {
        return $this->normalizeStr($sourceUri);
    }

    /**
     * @inheritdoc
     * @throws \InvalidArgumentException
     */
    public function normalizeStr($sourceUri)
    {
        if ($this->parser->matchString($sourceUri, $params) && !empty($params[1])) {
            if (!$this->mdtk) {
                throw new \InvalidArgumentException('mdtk option is undefined');
            }
            // renvoi des info
            $sourceUri = '/api/search/getvideoinfos/videoid/' . $params[1] . '/datatype/json/mdtk/' . $this->mdtk;
        }
        return $sourceUri;
    }
}
