<?php


namespace Move\Embed\Normalizer;

use Move\Embed\Parser\ParserInterface;

/**
 * Class YoutubeNormalizer
 * @package Move\Embed\Normalizer
 */
class YoutubeNormalizer implements NormalizerInterface
{
    /** @var ParserInterface */
    private $parser;

    /**
     * YoutubeNormalizer constructor.
     * @param ParserInterface $parser
     */
    public function __construct(ParserInterface $parser)
    {
        $this->parser = $parser;
    }

    /**
     * @param string $sourceUri
     * @return string
     */
    public function __invoke($sourceUri)
    {
        return 'https://www.youtube.com/watch?v=' . $sourceUri;
    }

    /**
     * @inheritdoc
     */
    public function normalizeStr($sourceUri)
    {
        if ($this->parser->matchString($sourceUri, $params) && !empty($params[1])) {
            return 'https://www.youtube.com/watch?v=' . $params[1];
        }
        return $sourceUri;
    }
}
