<?php

namespace Move\Template\Html\Asset;

/**
 * Class Favicon
 * @package Move\Template\Html\Asset
 */
class Favicon implements AssetInterface
{

    /** @var string */
    private $faviconPath;

    /** @var array */
    private $sizeList;

    /** @var string */
    private $ext;

    /** @var string */
    private $mimeType;

    /**
     * Favicon constructor.
     * @param string $faviconPath
     * @param array $sizeList
     * @param string $ext
     * @param string $mimeType
     */
    public function __construct($faviconPath, array $sizeList = [], $ext = 'png', $mimeType = 'image/png')
    {
        $this->faviconPath = $faviconPath;
        $this->ext = $ext;
        $this->mimeType = $mimeType;
        $this->setSizeList($sizeList);
    }

    /**
     * @param array $sizeList
     * @return $this
     */
    public function setSizeList(array $sizeList = [])
    {
        $this->sizeList = $sizeList ?: [16, 32, 48, 62, 192];
        return $this;
    }

    /**
     * Renvoi la copie sous forme de tableau de la metadata
     * @return array
     */
    public function getArrayCopy()
    {
        return [
            'sizeList' => $this->sizeList,
            'faviconPath' => $this->faviconPath,
        ];
    }

    /**
     * @return string
     */
    public function render()
    {
        $html = '';
        foreach ($this->sizeList as $size) {
            $html .= '<link rel="icon" href="'
                . $this->faviconPath . '/favicon-' . $size . '.' . $this->ext . '" sizes="'
                . $size . 'x' . $size . '" type="'
                . $this->mimeType . '">';
        }
        return $html;
    }

    /**
     * Effectue un rendu de l'objet en HTML
     * @return string
     */
    public function __toString()
    {
        return $this->render();
    }
}
