<?php

namespace Cms\Client\Contract;

use Cms\Client\AbstractClient;
use Cms\Client\ClientFetchStrategy;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\Contract\Model\ProductRestfulModel;

/**
 * Class ProductClient
 * @package Cms\Client\Contract
 */
class ProductClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'contract/product';

    /** @var string */
    protected $fetchStrategy = ClientFetchStrategy::FETCH_ASYNC;

    /**
     * @param array $dataset
     * @return ProductRestfulModel
     */
    public function handleData($dataset = []) : ProductRestfulModel
    {
        return (new ProductRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|ProductRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $configId
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Contract\Model\ProductRestfulModel[]
     */
    public function getIndexForConfig($configId)
    {
        $builder = $this->getBuilder()
            ->setFilter('config_id', $configId);
        return $builder->getIndex(-1);
    }
}
