<?php

namespace Cms\Model\Member;

use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class MemberLoginModel
 * @package Cms\Model\Member
 * @property int $member_id
 * @property string $password_hash
 * @property string $password_hash_type
 * @property string $reset_passwd_key
 * @property \DateTime $reset_passwd_at
 * @property bool $reset_passwd_used
 * @property string $state
 */
class MemberLoginModel extends DomainObjectAbstract
{
    use ScopeAwareModelTrait;
    use StampAwareModelTrait;

    /** @var  int */
    protected $member_id;

    /** @var  string */
    protected $password_hash;

    /** @var  string */
    protected $password_hash_type;

    /** @var  string */
    protected $reset_passwd_key;

    /** @var  \DateTime */
    protected $reset_passwd_at;

    /** @var  bool */
    protected $reset_passwd_used;

    /** @var  string */
    protected $state;
}
