<?php


namespace Move\Http\Client;

use GuzzleHttp\Promise\PromiseInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;

/**
 * Class HttpClientInterface
 * @package Move\Http\Client
 */
interface HttpClientInterface
{

    /**
     * effectue une requete
     * @param string $method
     * @param array $pathSegments
     * @param array $options
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @return ResponseInterface
     */
    public function request($method, array $pathSegments, $options = []);

    /**
     * effectue une requete asynchrone
     * @param string $method
     * @param array $pathSegments
     * @param array $options
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @return PromiseInterface
     */
    public function requestAsync($method, array $pathSegments, $options = []);

    /**
     * @param RequestInterface $request
     * @param array $options
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @return ResponseInterface
     */
    public function send(RequestInterface $request, $options = []);

    /**
     * @param RequestInterface $request
     * @param array $options
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @return PromiseInterface
     */
    public function sendAsync(RequestInterface $request, $options = []);
}
