<?php

namespace Move\Http\Strategy\Serializer;

use Move\Utils\Str;
use Psr\Http\Message\ResponseInterface;

/**
 * Class JsonSerializer
 * @package Move\Http\Strategy\Serializer
 */
class JsonSerializer implements SerializerInterface
{

    /**
     * @param mixed $dataset
     * @param ResponseInterface $response
     * @return string
     * @throws \InvalidArgumentException
     */
    public function serialize($dataset, ResponseInterface $response) : string
    {
        return Str::toJson($dataset);
    }

    /**
     * @param mixed $dataset
     * @param ResponseInterface $response
     * @return string
     * @throws \InvalidArgumentException
     */
    public function __invoke($dataset, ResponseInterface $response)
    {
        return $this->serialize($dataset, $response);
    }
}
