<?php


namespace Move\Newsletter;

use Move\Newsletter\Provider\MailjetAdapter;
use Move\Newsletter\Provider\MailjetConfirmAdapter;
use Move\Newsletter\Provider\MailjetNotifierAdapter;

/**
 * Class ProviderFactory
 * @package Move\Newsletter
 */
class ProviderFactory
{
    /**
     * @param string $apiKey
     * @param string $apiSecret
     * @param string $idList
     * @param array $confirmOpts
     * @param array $customProps
     * @return \Move\Newsletter\Provider\MailjetAdapter
     */
    public static function createMailJet(
        string $apiKey,
        string $apiSecret,
        string $idList,
        array $confirmOpts = [],
        array $customProps = []
    ) : MailjetAdapter {
        if (!empty($confirmOpts)) {
            return new MailjetConfirmAdapter($apiKey, $apiSecret, $idList, $confirmOpts, $customProps);
        }
        return new MailjetAdapter($apiKey, $apiSecret, $idList, $customProps);
    }

    /**
     * @param string $apiKey
     * @param string $apiSecret
     * @return \Move\Newsletter\Provider\MailjetNotifierAdapter
     */
    public static function createMailJetNotifier(
        string $apiKey,
        string $apiSecret
    ) : MailjetNotifierAdapter {
        return new MailjetNotifierAdapter($apiKey, $apiSecret);
    }

    /**
     * @param string $salt
     * @param string $subject
     * @param string $fromEmail
     * @param string $fromName
     * @param $templateId
     * @param string $confirmUrl
     * @param array $templateVars
     * @return array
     */
    public static function createMailJetConfirmOpts(
        string $salt,
        string $subject,
        string $fromEmail,
        string $fromName,
        $templateId,
        string $confirmUrl,
        array $templateVars = []
    ) : array {
        return [
            'salt' => $salt,
            'fromEmail' => $fromEmail,
            'fromName' => $fromName,
            'templateId' => $templateId,
            'templateVars' => $templateVars,
            'confirmUrl' => $confirmUrl,
            'subject' => $subject,
        ];
    }
}
