<?php

namespace Move\Template\Extensions;

use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;

/**
 * Class Translate
 * @package Move\Template\Extensions
 */
class Translate implements ExtensionInterface
{

    /**
     * Translate constructor.
     * @param string $domain
     * @param string $path
     * @param string $charset
     */
    public function __construct($domain, $path, $charset = 'UTF-8')
    {
        // configuration de gettext
        bindtextdomain($domain, $path);
        bind_textdomain_codeset($domain, $charset);
        textdomain($domain);
    }

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        $engine->registerFunction('_', [$this, 'runGettext']);
        $engine->registerFunction('_n', [$this, 'runNGettext']);
    }

    /**
     * @param string $message
     * @param array $args
     * @return string
     */
    public function runGettext($message, array $args = []) : string
    {
        return sprintf(gettext($message), ...$args);
    }

    /**
     * @param string $singulier
     * @param string $pluriel
     * @param int $nombre
     * @param array $args
     * @return string
     */
    public function runNGettext($singulier, $pluriel = null, $nombre = 0, array $args = []) : string
    {
        $message = ngettext($singulier, $pluriel ?: $singulier, $nombre);
        return sprintf($message, $nombre, ...$args);
    }
}
