<?php

namespace Move\Template\Html;

use Move\Utils\TaggedItemCollection;

/**
 * Interface RenderStrategyInterface
 * @package Move\Template\Html
 */
interface RenderStrategyInterface
{

    /**
     * Effectue le rendu d'une collection en suivant une strategie prédéfini
     * @param TaggedItemCollection $itemCollection
     * @param array $tags
     * @return string
     */
    public function render(TaggedItemCollection $itemCollection, array $tags);
}
