<?php

namespace Move\Iterator;

use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class MapIteratorTest
 * @package Move\Iterator
 */
class MapIteratorTest extends TestCase
{
    protected $inputArray = ['a','b','c'];
    protected $arg = ['x'];
    protected $expectedOutput = ['A-X', 'B-X', 'C-X'];

    /**
     * @covers MapIterator::__construct
     * @return MapIterator
     */
    public function testConstruct()
    {
        $callable = function($curr, $data) { return strtoupper($curr.'-'.$data);};
        $iterator = new \ArrayIterator($this->inputArray);
        $instance = new MapIterator($iterator, $callable, $this->arg);

        $this->assertInstanceOf(MapIterator::class, $instance);
        $this->assertEquals($callable, Reflection::getValue($instance, 'callback'));
        $this->assertEquals($this->arg, Reflection::getValue($instance, 'arguments'));

        return $instance;
    }

    /**
     * @covers MapIterator::current
     * @depends testConstruct
     * @param MapIterator $instance
     */
    public function testCurrent(MapIterator $instance)
    {
        $parsedToArray = iterator_to_array($instance);
        $this->assertEquals($this->expectedOutput, $parsedToArray);
    }
}
