<?php

namespace Move\Specification;

use PHPUnit\Framework\TestCase;

/**
 * Class EmptySpecificationTest
 * @package Move\Specification
 */
class EmptySpecificationTest extends TestCase
{
    /**
     * @return array
     */
    public static function provideEmptyValues() {
        return [
            ['', true],
            [[], true],
            [null, true],
            [0, true],
            ['0', true], /* ???? */
            ['abc', false],
            [[0], false],
        ];
    }

    /**
     * @covers EmptySpecification::isSatisfiedBy
     * @dataProvider provideEmptyValues
     * @param $object
     * @param $expected
     */
    public function testIsSatisfiedBy($object, $expected)
    {
        $spec = new EmptySpecification();
        $this->assertEquals(
            $expected,
            $spec->isSatisfiedBy($object)
        );
    }
}
