<?php


namespace Cms\Client\Service;

use Cms\Client\Contract\ContractClient;
use Cms\Client\Contract\ProductClient;
use Cms\Client\Contract\ProductConfigClient;
use Cms\Client\Contract\Tansformer\ContractTransformer;
use Cms\Client\Contract\Tansformer\ProductConfigTransformer;
use Move\Command\CommandBusInterface;
use Move\ObjectMapper\ObjectTransformer;

/**
 * Class ContractService
 * @package Cms\Client\Service
 */
class ContractService
{

    /**
     * @var ContractClient
     */
    private $contractClient;

    /**
     * @var ContractTransformer|ObjectTransformer
     */
    private $contractTransformer;

    /**
     * @var ProductConfigClient
     */
    private $configClient;

    /**
     * @var ProductConfigTransformer|ObjectTransformer
     */
    private $configTransformer;

    /** @var \Cms\Client\Contract\ProductClient */
    private $productClient;

    /** @var \Move\ObjectMapper\ObjectTransformer */
    private $productTransformer;

    /** @var \Move\Command\CommandBusInterface */
    private $contractBus;

    /**
     * ContractService constructor.
     * @param ContractClient $contractClient
     * @param \Move\Command\CommandBusInterface $contractBus
     * @param \Cms\Client\Contract\ProductClient $productClient
     * @param ProductConfigClient $configClient
     * @param ObjectTransformer $contractTransformer
     * @param ObjectTransformer $configTransformer
     */
    public function __construct(
        ContractClient $contractClient,
        CommandBusInterface $contractBus,
        ProductClient $productClient,
        ProductConfigClient $configClient,
        ObjectTransformer $contractTransformer,
        ObjectTransformer $configTransformer
    ) {
        $this->contractClient = $contractClient;
        $this->productClient = $productClient;
        $this->configClient = $configClient;
        $this->contractTransformer = $contractTransformer;
        $this->productTransformer = new ObjectTransformer();
        $this->configTransformer = $configTransformer;
        $this->contractBus = $contractBus;
    }

    /**
     * @return ContractClient
     */
    public function getContractClient() : ContractClient
    {
        return $this->contractClient;
    }

    /**
     * @return ObjectTransformer|ContractTransformer
     */
    public function getContractTransformer() : ObjectTransformer
    {
        return $this->contractTransformer;
    }

    /**
     * @return ProductConfigClient
     */
    public function getConfigClient() : ProductConfigClient
    {
        return $this->configClient;
    }

    /**
     * @return ObjectTransformer|ProductConfigTransformer
     */
    public function getConfigTransformer() : ObjectTransformer
    {
        return $this->configTransformer;
    }

    /**
     * @return \Cms\Client\Contract\ProductClient
     */
    public function getProductClient() : ProductClient
    {
        return $this->productClient;
    }

    /**
     * @return \Move\ObjectMapper\ObjectTransformer
     */
    public function getProductTransformer() : ObjectTransformer
    {
        return $this->productTransformer;
    }

    /**
     * @return \Move\Command\CommandBusInterface
     */
    public function getCommandBus() : CommandBusInterface
    {
        return $this->contractBus;
    }
}
