<?php


namespace Cms\Client\Service;

use Cms\Client\Member\MemberClient;
use Move\Command\CommandBusInterface;
use Move\ObjectMapper\ObjectTransformer;

/**
 * Class MemberService
 * @package Cms\Client\Service
 */
class MemberService
{

    /**
     * @var MemberClient
     */
    private $memberClient;

    /** @var CommandBusInterface */
    private $commandBus;

    /** @var ObjectTransformer */
    private $memberTransformer;

    /**
     * MemberService constructor.
     * @param MemberClient $memberClient
     * @param CommandBusInterface $commandBus
     * @param ObjectTransformer $memberTransformer
     */
    public function __construct(
        MemberClient $memberClient,
        CommandBusInterface $commandBus,
        ObjectTransformer $memberTransformer
    ) {
        $this->memberClient = $memberClient;
        $this->commandBus = $commandBus;
        $this->memberTransformer = $memberTransformer;
    }

    /**
     * @return MemberClient
     */
    public function getMemberClient()
    {
        return $this->memberClient;
    }

    /**
     * @return CommandBusInterface
     */
    public function getCommandBus()
    {
        return $this->commandBus;
    }

    /**
     * @return ObjectTransformer
     */
    public function getMemberTransformer()
    {
        return $this->memberTransformer;
    }
}
