<?php

namespace Cms\Model\Contract\Product;

use Cms\LinkResource\LinkResourceType;
use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class ProductConfigValidator
 * @package Cms\Model\Contract\Product
 */
class ProductConfigValidator extends AbstractDomainObjectStateValidator
{
    /**
     * @return Filter
     * @throws \InvalidArgumentException
     */
    protected function createFilter() : Filter
    {
        // filtre du model
        $myFilter = new Filter([
            'product_id' => true,
            'link_provider' => true,
            'link_type' => new EnumSpecification(LinkResourceType::class),
            'link_ref' => true,
            'state' => new EnumSpecification(ProductConfigState::class),
        ]);
        return $myFilter;
    }
}
