<?php

namespace Move\Cache;

use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;
use Psr\Cache\CacheItemPoolInterface;

/**
 * Class CacheAwareTest
 */
class CacheAwareTest extends TestCase
{

    /**
     * @return CacheAwareTrait
     */
    public function testGetItemCachePoolEmpty()
    {
        /** @var  CacheAwareTrait|\PHPUnit_Framework_MockObject_MockObject $cache */
        $cache = $this->getMockForTrait(CacheAwareTrait::class);
        $this->assertNull($cache->getItemCachePool());
        return $cache;
    }

    /**
     * @depends      testGetItemCachePoolEmpty
     * @param CacheAwareTrait $cache
     * @return CacheAwareTrait
     */
    public function testSetItemCachePool($cache)
    {
        /** @var CacheItemPoolInterface|\PHPUnit_Framework_MockObject_MockObject $cachePool */
        $cachePool = $this->createMock(CacheItemPoolInterface::class);
        $this->assertEquals($cachePool, $cache->setItemCachePool($cachePool));
        $this->assertEquals($cachePool, Reflection::getValue($cache, 'pool'));
        return $cache;
    }

    /**
     * @depends      testSetItemCachePool
     * @param CacheAwareTrait $cache
     */
    public function testGetItemCachePool($cache)
    {
        $this->assertInstanceOf(
            CacheItemPoolInterface::class,
            $cache->getItemCachePool()
        );
    }
}
