<?php

namespace Move\Command\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class CreateCommandTest
 */
class CreateCommandTest extends TestCase
{

    /**
     * @return array
     */
    public function provideDataset()
    {
        return [
            [
                ['title' => "Title de l'article", 'has_data' => true, 'abstract' => null],
            ],
            [
                ['title' => "Title de l'article", 'has_data' => true, 'abstract' => null],
            ]
        ];
    }

    public function provideDryRun()
    {
        return [
            'with DryRun' => [true,],
            'without DryRun' => [false,]
        ];
    }


    /**
     * @dataProvider provideDataset
     * @param array $dataset
     * @return \Move\Command\Command\CreateCommand
     */
    public function testConstructCommand(array $dataset)
    {
        $command = new CreateCommand($dataset);
        $this->assertEquals($dataset, $command->getDataset());
        $this->assertFalse($command->isDryRun());

        return $command;
    }

    /**
     * @depends testConstructCommand
     * @dataProvider provideDryRun
     * @param bool $isDryRun
     */
    public function testWithDryRun(bool $isDryRun)
    {
        $command = new CreateCommand([]);
        $this->assertFalse($command->isDryRun());
        $this->assertNotSame($command, $dryRunCmd = $command->withDryRun($isDryRun));
        $this->assertEquals($isDryRun, $dryRunCmd->isDryRun());
    }

    /**
     * @depends testConstructCommand
     * @dataProvider provideDataset
     * @param $dataset
     */
    public function testWithDataset($dataset)
    {
        $command = new CreateCommand([]);
        $this->assertEmpty($command->getDataset());
        $this->assertNotSame($command, $dataCmd = $command->withDataset($dataset));
        $this->assertEquals($dataset, $dataCmd->getDataset());
    }
}