<?php

namespace Move\Image;

use PHPUnit\Framework\TestCase;

/**
 * Class ImageTest
 * @package Move\Image
 */
class ImageTest extends TestCase
{
    /** @var  string image raw */
    protected $raw;

    /** @var string image path */
    protected $path = __DIR__ .'/file/picture.jpg';

    /**
     * @inheritdocs
     */
    public function setUp()
    {
        if (!$this->raw) {
            $this->raw = file_get_contents($this->path);
        }
    }

    /**
     * @covers Image::__construct
     * @return Image
     */
    public function testConstruct()
    {
        $instance = new Image($this->raw);
        $this->assertInstanceOf(Image::class, $instance);
        return $instance;
    }

    /**
     * @covers Image::__toString
     * @depends testConstruct
     * @param Image $instance
     */
    public function testToString(Image $instance)
    {
        $stringRes = ''.$instance;
        $image2 = new Image($stringRes);
        $this->assertInstanceOf(Image::class, $image2);
    }

}
