<?php


namespace Cms\Client\Contract\Tansformer;

use Cms\Client\Contract\Model\ProductConfigRestfulModel;
use Move\ObjectMapper\ObjectTransformer;
use POM\DomainObjectInterface;

/**
 * Class ProductConfigTransformer
 * @package Cms\Client\Contract\Tansformer
 */
class ProductConfigTransformer extends ObjectTransformer
{

    /**
     * @param \POM\DomainObjectInterface $object
     * @return array
     */
    public function transform(DomainObjectInterface $object)
    {
        $dataset = parent::transform($object);
        if ($object instanceof ProductConfigRestfulModel) {
            return $dataset;
        }

        // convertion de l'url si mauvais format
        $dataset['config'] = $this->transformConfig($dataset['config'] ?: []);
        foreach ($dataset['i18n'] ?: [] as &$item) {
            $item['config'] = $this->transformConfig($item['config'] ?: []);
        }
        return $dataset;
    }

    /**
     * @param array $config
     * @return array
     */
    protected function transformConfig(array $config) : array
    {
        if (!empty($config['url'])
            && !preg_match('@^https?:@', $config['url'])
        ) {
            $config['url'] = 'http://' . $config['url'];
        }

        return $config;
    }
}
