<?php


namespace Cms\Client\Service;

use Cms\Client\CmsStatsHttpClientInterface;
use Cms\Client\Stats\AlsoViewedClient;
use League\Container\ServiceProvider\AbstractServiceProvider;

/**
 * Class CmsStatsProvider
 * @package Cms\Client\Service
 */
class CmsStatsProvider extends AbstractServiceProvider
{

    /** @var array */
    protected $provides = [
        AlsoViewedClient::class,
        CmsStatsService::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add user client
        $this->container->add(AlsoViewedClient::class)
            ->withArgument(CmsStatsHttpClientInterface::class);

        // add service
        $this->container->add(CmsStatsService::class)
            ->withArgument(AlsoViewedClient::class);
    }
}
