<?php


namespace Cms\Client\Service;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\Command\Contract\Command\FetchAllContractByFilterCommand;
use Cms\Client\Command\Contract\ContractCommandHandler;
use Cms\Client\Contract\ContractClient;
use Cms\Client\Contract\ProductClient;
use Cms\Client\Contract\ProductConfigClient;
use Cms\Client\Contract\Tansformer\ContractTransformer;
use Cms\Client\Contract\Tansformer\ProductConfigTransformer;
use League\Container\Argument\RawArgument;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Tactician\Handler\MethodNameInflector\HandleClassNameWithoutSuffixInflector;
use Move\Command\TacticianBusFactory;

/**
 * Class ContractProvider
 * @package Cms\Client\Service
 */
class ContractProvider extends AbstractServiceProvider
{

    /** @var array */
    protected $provides = [
        ContractService::class,
        ContractClient::class,
        ContractCommandHandler::class,
        ProductConfigClient::class,
        ContractTransformer::class,
        ProductConfigTransformer::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add clients
        $this->container->add(ContractClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(ProductConfigClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(ProductClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // creation du bus de command
        $contractBus = TacticianBusFactory::containerMap($this->container, [
            FetchAllContractByFilterCommand::class => ContractCommandHandler::class,
        ], new HandleClassNameWithoutSuffixInflector());

        // declaration des deps
        $this->container->add(ContractTransformer::class);
        $this->container->add(ProductConfigTransformer::class);
        $this->container->add(ContractCommandHandler::class)
            ->withArguments([
                ContractClient::class,
            ]);

        // add services
        $this->container->add(ContractService::class)
            ->withArguments([
                ContractClient::class,
                new RawArgument($contractBus),
                ProductClient::class,
                ProductConfigClient::class,
                ContractTransformer::class,
                ProductConfigTransformer::class,
            ]);
    }
}
