<?php


namespace Cms\Model\Article;

use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\SeoAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class ArticleModel
 * @package Cms\Model\Article
 * @property int $id
 * @property int $container_id
 * @property int $draft_for_article_id
 * @property int $category_id
 * @property ArticleProfil $profil
 * @property string $title
 * @property string $cover_title
 * @property string $short_title
 * @property string $slug
 * @property ArticleContent $abstract
 * @property ArticleContent $cover_abstract
 * @property string $short_abstract
 * @property ArticleContent $content
 * @property string $author_signature
 * @property ArticleState $state
 * @property bool $cover_flag
 * @property string $parution_num
 * @property \DateTime $first_published_at
 * @property \DateTime $last_published_at
 */
class ArticleModel extends DomainObjectAbstract
{
    use SeoAwareModelTrait;
    use StampAwareModelTrait;
    use ScopeAwareModelTrait;
    use CmsUserIdAwareTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $container_id;

    /** @var  int */
    protected $category_id;

    /** @var  int */
    protected $draft_for_article_id;

    /** @var  ArticleProfil */
    protected $profil;

    /** @var  string */
    protected $title;

    /** @var  string */
    protected $cover_title;

    /** @var  string */
    protected $short_title;

    /** @var  string */
    protected $slug;

    /** @var  ArticleContent */
    protected $abstract;

    /** @var  ArticleContent */
    protected $cover_abstract;

    /** @var  string */
    protected $short_abstract;

    /** @var  ArticleContent */
    protected $content;

    /** @var  ArticleState */
    protected $state;

    /** @var  string */
    protected $author_signature;

    /** @var  bool */
    protected $cover_flag;

    /** @var  string */
    protected $parution_num;

    /** @var  \DateTime */
    protected $last_published_at;

    /** @var  \DateTime */
    protected $first_published_at;
}
