<?php

namespace Move\Embed;

use Move\Http\Client\HttpClientInterface;
use PHPUnit\Framework\TestCase;
use Psr\Cache\CacheItemPoolInterface;

/**
 * Class EmbedFactoryTest
 * @package Move\Embed
 */
class EmbedFactoryTest extends TestCase
{
    /**
     * @covers EmbedFactory::createClient
     */
    public function testCreateClient()
    {
        $instance = EmbedFactory::createClient('youtube.com');
        $this->assertInstanceOf(HttpClientInterface::class, $instance);
    }

    /**
     * @covers EmbedFactory::createMapper
     */
    public function testCreateMapper()
    {
        $instance = EmbedFactory::createMapper('123456');
        $this->assertInstanceOf(EmbedMapper::class, $instance);
    }

    /**
     * @covers EmbedFactory::createMapperWithCache
     */
    public function testCreateMapperWithCache()
    {
        /** @var CacheItemPoolInterface $cachePool */
        $cachePool = $this
            ->getMockBuilder(CacheItemPoolInterface::class)
            ->getMock();

        $instance = EmbedFactory::createMapperWithCache($cachePool);
        $this->assertInstanceOf(EmbedMapper::class, $instance);

        $instance = EmbedFactory::createMapperWithCache($cachePool, '123456');
        $this->assertInstanceOf(EmbedMapper::class, $instance);
    }
}
