<?php

namespace Cms\Bundle\Member\Exception;

use Cms\Bundle\Member\MemberErrorCode;

/**
 * Class MemberNotFoundException
 * @package Cms\Bundle\Member\Exception
 */
class MemberNotFoundException extends RuntimeException
{
    /** @var string */
    private $identifier;

    /**
     * MemberNotFoundException constructor.
     * @param string $identifier
     * @param \Throwable|null $previous
     */
    public function __construct(string $identifier, \Throwable $previous = null)
    {
        $message = 'member not found with identifier : ' . $identifier;
        parent::__construct($message, MemberErrorCode::MEMBER_NOT_FOUND, $previous);
        $this->identifier = $identifier;
    }

    /**
     * @return string
     */
    public function getIdentifier() : string
    {
        return $this->identifier;
    }
}
