<?php

namespace Cms\Bundle\Member\Exception;

use Cms\Bundle\Member\MemberErrorCode;

/**
 * Class PasswordFailedException
 * @package Cms\Bundle\Member\Exception
 */
class PasswordFailedException extends FieldException
{

    /**
     * PasswordFailedException constructor.
     * @param string|null $code
     * @param \Exception|null $previous
     */
    public function __construct(
        $code = null,
        \Exception $previous = null
    ) {
        parent::__construct(
            'password',
            $code ?: MemberErrorCode::PASSWORD_FAILED,
            $previous
        );
    }
}
