<?php

namespace Cms\Client\Service;

use Cms\Client\Campsite\CampsiteClient;
use Cms\Client\Campsite\CampsiteLogClient;
use Cms\Client\Campsite\CampsitePubClient;
use Cms\Client\Campsite\FeatureClient;
use Cms\Client\Campsite\GroupClient;
use Cms\Client\Campsite\GuideClient;
use Cms\Client\Campsite\ProductClient;
use Cms\Client\Campsite\PubClient;
use Cms\Client\Campsite\ThematicClient;
use Cms\Client\Campsite\Transformer\CampsiteTransformer;
use Cms\Client\Campsite\Transformer\FeatureTransformer;
use Cms\Client\Campsite\Transformer\GroupTransformer;
use Cms\Client\Campsite\Transformer\ProductTransformer;
use Move\Command\CommandBusInterface;
use Move\ObjectMapper\ObjectTransformer;

/**
 * Class CampsiteService
 * @package Cms\Client\Service
 */
class CampsiteService
{

    /** @var CampsiteClient */
    private $campsiteClient;

    /** @var GroupClient */
    private $groupClient;

    /** @var  FeatureClient */
    private $featureClient;

    /** @var \Cms\Client\Campsite\ProductClient */
    private $productClient;

    /** @var \Cms\Client\Campsite\GuideClient */
    private $guideClient;

    /** @var \Cms\Client\Campsite\PubClient */
    private $pubClient;

    /** @var \Cms\Client\Campsite\CampsitePubClient */
    private $campsitePubClient;

    /** @var \Cms\Client\Campsite\ThematicClient */
    private $thematicClient;

    /** @var ObjectTransformer|CampsiteTransformer */
    private $campsiteTransformer;

    /** @var ObjectTransformer|GroupTransformer */
    private $groupTransformer;

    /** @var  ObjectTransformer|FeatureTransformer */
    private $featureTransformer;

    /** @var ProductTransformer|ObjectTransformer */
    private $productTransformer;

    /** @var \Move\ObjectMapper\ObjectTransformer */
    private $guideTransformer;

    /** @var \Move\ObjectMapper\ObjectTransformer */
    private $pubTransformer;

    /** @var \Move\ObjectMapper\ObjectTransformer */
    private $thematicTransformer;

    /** @var \Move\Command\CommandBusInterface */
    private $campsiteBus;

    /** @var \Move\Command\CommandBusInterface */
    private $thematicBus;

    /** @var \Move\Command\CommandBusInterface */
    private $productBus;

    /** @var \Cms\Client\Campsite\CampsiteLogClient */
    private $logClient;

    /**
     * CampsiteService constructor.
     * @param \Cms\Client\Campsite\CampsiteClient $campsiteClient
     * @param \Move\Command\CommandBusInterface $campsiteBus
     * @param \Cms\Client\Campsite\CampsiteLogClient $logClient
     * @param \Cms\Client\Campsite\GroupClient $groupClient
     * @param \Cms\Client\Campsite\FeatureClient $featureClient
     * @param \Cms\Client\Campsite\ProductClient $productClient
     * @param \Move\Command\CommandBusInterface $productBus
     * @param \Cms\Client\Campsite\GuideClient $guideClient
     * @param \Cms\Client\Campsite\PubClient $pubClient
     * @param \Cms\Client\Campsite\CampsitePubClient $campsitePubClient
     * @param \Cms\Client\Campsite\ThematicClient $thematicClient
     * @param \Move\Command\CommandBusInterface $thematicBus
     * @param ObjectTransformer|CampsiteTransformer $campsiteTransformer
     * @param ObjectTransformer|GroupTransformer $groupTransformer
     * @param ObjectTransformer|FeatureTransformer $featureTransformer
     * @param ObjectTransformer|ProductTransformer $productTransformer
     * @param \Move\ObjectMapper\ObjectTransformer|null $guideTransformer
     * @param \Move\ObjectMapper\ObjectTransformer|null $thematicTransformer
     * @param \Move\ObjectMapper\ObjectTransformer|null $pubTransformer
     */
    public function __construct(
        CampsiteClient $campsiteClient,
        CommandBusInterface $campsiteBus,
        CampsiteLogClient $logClient,
        GroupClient $groupClient,
        FeatureClient $featureClient,
        ProductClient $productClient,
        CommandBusInterface $productBus,
        GuideClient $guideClient,
        PubClient $pubClient,
        CampsitePubClient $campsitePubClient,
        ThematicClient $thematicClient,
        CommandBusInterface $thematicBus,
        ObjectTransformer $campsiteTransformer,
        ObjectTransformer $groupTransformer,
        ObjectTransformer $featureTransformer,
        ObjectTransformer $productTransformer,
        ObjectTransformer $guideTransformer = null,
        ObjectTransformer $thematicTransformer = null,
        ObjectTransformer $pubTransformer = null
    ) {
        $this->campsiteClient = $campsiteClient;
        $this->campsiteBus = $campsiteBus;

        $this->logClient = $logClient;

        $this->groupClient = $groupClient;
        $this->featureClient = $featureClient;
        $this->guideClient = $guideClient;
        $this->pubClient = $pubClient;
        $this->campsitePubClient = $campsitePubClient;

        $this->productClient = $productClient;
        $this->productBus = $productBus;

        $this->thematicClient = $thematicClient;
        $this->thematicBus = $thematicBus;

        $this->campsiteTransformer = $campsiteTransformer;
        $this->groupTransformer = $groupTransformer;
        $this->featureTransformer = $featureTransformer;
        $this->productTransformer = $productTransformer;
        $this->guideTransformer = $guideTransformer ?: new ObjectTransformer();
        $this->pubTransformer = $pubTransformer ?: new ObjectTransformer();
        $this->thematicTransformer = $thematicTransformer ?: new ObjectTransformer();
    }

    /**
     * @return CampsiteClient
     */
    public function getCampsiteClient() : CampsiteClient
    {
        return $this->campsiteClient;
    }

    /**
     * @return ObjectTransformer|CampsiteTransformer
     */
    public function getCampsiteTransformer() : ObjectTransformer
    {
        return $this->campsiteTransformer;
    }

    /**
     * @return \Move\Command\CommandBusInterface
     */
    public function getCampsiteBus() : CommandBusInterface
    {
        return $this->campsiteBus;
    }

    /**
     * @return GroupClient
     */
    public function getGroupClient() : GroupClient
    {
        return $this->groupClient;
    }

    /**
     * @return ObjectTransformer|GroupTransformer
     */
    public function getGroupTransformer() : ObjectTransformer
    {
        return $this->groupTransformer;
    }

    /**
     * @return ObjectTransformer|FeatureTransformer
     */
    public function getFeatureTransformer() : ObjectTransformer
    {
        return $this->featureTransformer;
    }

    /**
     * @return FeatureClient
     */
    public function getFeatureClient() : FeatureClient
    {
        return $this->featureClient;
    }

    /**
     * @return \Cms\Client\Campsite\GuideClient
     */
    public function getGuideClient() : GuideClient
    {
        return $this->guideClient;
    }

    /**
     * @return ObjectTransformer
     */
    public function getGuideTransformer() : ObjectTransformer
    {
        return $this->guideTransformer;
    }

    /**
     * @return \Cms\Client\Campsite\ProductClient
     */
    public function getProductClient() : ProductClient
    {
        return $this->productClient;
    }

    /**
     * @return ProductTransformer|ObjectTransformer
     */
    public function getProductTransformer() : ObjectTransformer
    {
        return $this->productTransformer;
    }

    /**
     * @return \Cms\Client\Campsite\PubClient
     */
    public function getPubClient() : PubClient
    {
        return $this->pubClient;
    }

    /**
     * @return \Move\ObjectMapper\ObjectTransformer
     */
    public function getPubTransformer() : ObjectTransformer
    {
        return $this->pubTransformer;
    }

    /**
     * @return \Cms\Client\Campsite\ThematicClient
     */
    public function getThematicClient() : ThematicClient
    {
        return $this->thematicClient;
    }

    /**
     * @return \Move\ObjectMapper\ObjectTransformer
     */
    public function getThematicTransformer() : ObjectTransformer
    {
        return $this->thematicTransformer;
    }

    /**
     * @return \Move\Command\CommandBusInterface
     */
    public function getThematicBus() : CommandBusInterface
    {
        return $this->thematicBus;
    }

    /**
     * @return \Move\Command\CommandBusInterface
     */
    public function getProductBus() : CommandBusInterface
    {
        return $this->productBus;
    }

    /**
     * @return \Cms\Client\Campsite\CampsitePubClient
     */
    public function getCampsitePubClient() : CampsitePubClient
    {
        return $this->campsitePubClient;
    }

    /**
     * @return \Cms\Client\Campsite\CampsiteLogClient
     */
    public function getLogClient() : CampsiteLogClient
    {
        return $this->logClient;
    }
}
