<?php

namespace Cms\Model\Campsite\Feature;

use Cms\Model\AbstractModelCollection;
use POM\DomainObjectInterface;

/**
 * Class FeatureI18nCollection
 * @package Cms\Model\Campsite\Feature
 */
class FeatureI18nCollection extends AbstractModelCollection
{

    /**
     * FeatureI18nCollection constructor.
     * @param array|null $models
     */
    public function __construct(array $models = null)
    {
        foreach ($models ?: [] as $model) {
            if (\is_array($model)) {
                $this->addItem($model);
            }
        }
    }

    /**
     * @param array $modelData
     * @return \POM\DomainObjectInterface
     */
    public function handleModel(array $modelData) : DomainObjectInterface
    {
        return (new FeatureI18nModel())->populate($modelData, true);
    }
}
