<?php

namespace Cms\Model\Contract\Product;

use Cms\LinkResource\AbstractLinkResourceCollection;

/**
 * Class ProductConfigResourceCollection
 * @package Cms\Model\Contract\Product
 */
class ProductConfigResourceCollection extends AbstractLinkResourceCollection
{
    /**
     * @param array|\Cms\LinkResource\AbstractLinkResourceModel $resourceData
     * @return ProductConfigResourceModel
     */
    public function handleResource($resourceData)
    {
        if (!$resourceData instanceof ProductConfigResourceModel) {
            $resourceData = (new ProductConfigResourceModel())->populate($resourceData, true);
        }
        return $resourceData;
    }
}
