<?php

namespace Cms\Search;

/**
 * Class SortableSearchResultsTrait
 * @package Cms\Search
 */
trait SortableSearchTrait
{

    /**
     * @param array $sortCols
     * @param array $predefinedCols
     * @param array $defaultSort
     * @return array
     */
    protected function parseSortCols(
        array $sortCols,
        array $predefinedCols = [],
        array $defaultSort = []
    ) {
        //
        $predefinedCols = $predefinedCols ?: $this->sortCols;

        // ajoute les params de recherche
        $sortParam = array_map(function ($sortOrder) {
            return \is_string($sortOrder) ? strtolower($sortOrder) : $sortOrder;
        }, array_filter($sortCols, function ($value, $sortCol) use ($predefinedCols) {
            return \in_array($sortCol, $predefinedCols)
                && (\is_array($value) || \in_array(strtolower($value), ['desc', 'asc']));
        }, ARRAY_FILTER_USE_BOTH)) ?: $defaultSort ?: ['_score'];
        return $sortParam;
    }
}
