<?php

namespace Cms\Worker\Scheduler;

use Cms\Worker\Command\Scheduler\SchedulerCommand;

/**
 * Class SchedulerCommandHandler
 * @package Cms\Worker\Scheduler
 */
class SchedulerCommandHandler extends AbstractSchedulerCommandHandler
{
    /**
     * @param SchedulerCommand $command
     * @throws \UnexpectedValueException
     * @throws \InvalidArgumentException
     * @throws \LogicException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \RuntimeException
     */
    public function handle(SchedulerCommand $command)
    {
        // On récupère toutes les tâches
        $tasks = $this->taskClient->getTaskForExecution($command->getScopeId(), $command->getLimitRunningJob());

        // Pour chacune des tâches, on lance l'exécution
        foreach ($tasks as $task) {
            $result = $this->run($task);
            if ($result) {
                $this->execTask($task);
            }
        }
    }
}
