<?php

namespace Move\Command\Chain;

/**
 * Interface HandlerInterface
 * @package Move\Command\Chain
 */
interface HandlerInterface
{

    /**
     * Sets a successor handler,
     * in case the class is not able to satisfy the request.
     * @param HandlerInterface $handler
     */
    public function setSuccessor(HandlerInterface $handler);

    /**
     * Handles the request or redirect the request
     * to the successor, if the process response is null.
     * @param string|array $data
     * @return string
     */
    public function handle($data);
}
