<?php

namespace Move\Embed\AdapterProvider;

use Move\Command\Chain\AbstractHandler;
use Move\Embed\Adapter\AdapterInterface;
use Move\Embed\Parser\ParserInterface;

/**
 * Class ProviderAbstract
 * @package Embed\AdapterProvider
 */
abstract class AbstractAdapterProvider extends AbstractHandler implements AdapterProviderInterface
{

    /**
     * Processes the request.
     * This is the only method a child can implements,
     * with the constraint to return null to dispatch the request to next successor.
     * @param string $sourceUri
     * @return null|AdapterInterface
     * @throws \UnexpectedValueException
     */
    protected function process($sourceUri)
    {
        $parser = $this->getParser();
        if (!$parser instanceof ParserInterface) {
            throw new \UnexpectedValueException('getParser must return a ParserInterface');
        }
        if ($parser->matchString($sourceUri) === true) {
            $adapter = $this->getAdapter();
            return $adapter;
        }
        return null;
    }

    /**
     * @return ParserInterface
     */
    abstract public function getParser();

    /**
     * @return AdapterInterface
     * @internal param array $uriParams
     */
    abstract public function getAdapter();
}
