<?php


namespace Move\Embed\Parser;

/**
 * Class MultiRegexParser
 * @package Move\Embed\Parser
 */
class MultiRegexParser implements ParserInterface
{
    /** @var RegexParser[] */
    private $regexs;

    /**
     * MultiRegexParser constructor.
     * @param array $regexs
     */
    public function __construct(array $regexs)
    {
        $this->regexs = array_map(function ($regex) {
            return new RegexParser($regex);
        }, $regexs);
    }


    /**
     * @param string $sourceUri
     * @param array $extractedParams
     * @return bool
     */
    public function __invoke($sourceUri, &$extractedParams = [])
    {
        return $this->matchString($sourceUri, $extractedParams) === 1;
    }

    /**
     * @param string $str
     * @param array $extractedParams
     * @return bool
     */
    public function matchString($str, &$extractedParams = [])
    {
        foreach ($this->regexs as $parser) {
            if ($parser->matchString($str, $extractedParams)) {
                return true;
            }
        }
        return false;
    }
}
