<?php


namespace Move\Http\Controller;

use Move\Http\ResponseUtils;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response;

/**
 * Class ResourceCorsOptionsTrait
 * @package Move\Http\Controller
 */
trait ResourceCorsOptionsTrait
{

    /** @var string|array */
    protected $corsMethodsAllowed = ['GET', 'PUT', 'DELETE', 'POST', 'HEAD'];

    /** @var string|array */
    protected $corsHeadersAllowed = ['Accept', 'Content-type', 'X-Requested-With', 'Authorization'];

    /** @var int|string */
    protected $corsMaxAge = 3600;

    /** @var string|array */
    protected $corsOrigin = '*';

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param array $vars
     * @return \Psr\Http\Message\ResponseInterface|\Zend\Diactoros\Response\EmptyResponse
     */
    public function options(ServerRequestInterface $request, ResponseInterface $response, $vars = [])
    {
        $response = new Response\EmptyResponse();
        return $this->withCorsHeaders($response);
    }

    /**
     * @param ResponseInterface $message
     * @return \Psr\Http\Message\MessageInterface|ResponseInterface
     */
    protected function withCorsHeaders(ResponseInterface $message)
    {
        return ResponseUtils::withCORSHeaders(
            $message,
            $this->corsOrigin,
            $this->corsHeadersAllowed,
            $this->corsMethodsAllowed,
            true,
            $this->corsMaxAge
        );
    }

    /**
     * @param array|string $corsMethodsAllowed
     */
    public function setCorsMethodsAllowed($corsMethodsAllowed)
    {
        $this->corsMethodsAllowed = $corsMethodsAllowed;
    }

    /**
     * @param array|string $corsHeadersAllowed
     */
    public function setCorsHeadersAllowed($corsHeadersAllowed)
    {
        $this->corsHeadersAllowed = $corsHeadersAllowed;
    }

    /**
     * @param int $corsMaxAge
     */
    public function setCorsMaxAge($corsMaxAge)
    {
        $this->corsMaxAge = $corsMaxAge;
    }

    /**
     * @param array|string $corsOrigin
     */
    public function setCorsOrigin($corsOrigin)
    {
        $this->corsOrigin = $corsOrigin;
    }

    /**
     * @return array
     */
    protected function getCorsHeaders()
    {
        return ResponseUtils::getCORSHeaders(
            $this->corsOrigin,
            $this->corsHeadersAllowed,
            $this->corsMethodsAllowed,
            true,
            $this->corsMaxAge
        );
    }
}
