<?php

namespace Move\Template\Html\Asset;

use Move\Utils\Str;

/**
 * Class Xiti
 * @package Move\Template\Html\Asset
 */
class Xiti implements AssetInterface
{
    /** @var  string */
    protected static $XTSITE;

    /** @var  string */
    protected static $XTCORE_URL;

    /** @var  string */
    protected static $XTSD;

    /** @var  string */
    protected static $XTJOIN_CHAR;


    /**
     * @var string
     */
    private $xtn2;

    /**
     * @var array
     */
    private $xtPage;


    /**
     * @param string $xtsite
     * @param string $xtsd
     * @param string $xtcoreUrl
     * @param string $joinChar
     */
    public static function Configure($xtsite, $xtsd, $xtcoreUrl = '/js/xtcore.js', $joinChar = '_')
    {
        self::$XTSITE = $xtsite;
        self::$XTSD = $xtsd;
        self::$XTCORE_URL = $xtcoreUrl;
        self::$XTJOIN_CHAR = $joinChar;
    }


    /**
     * Xiti constructor.
     * @param string $xtn2
     * @param array $xtPage
     */
    public function __construct($xtn2, array $xtPage = [])
    {
        $this->xtn2 = $xtn2;
        $this->xtPage = $xtPage;
    }

    /**
     * Renvoi la copie sous forme de tableau de la metadata
     * @return array
     */
    public function getArrayCopy()
    {
        return [
            'xtn2' => $this->xtn2,
            'xtpage' => $this->xtPage,
            'xtsd' => self::$XTSD,
            'xtsite' => self::$XTSITE,
            'xtcore_url' => self::$XTCORE_URL,
            'xtjoin_char' => self::$XTJOIN_CHAR,
        ];
    }

    /**
     * Effectue un rendu de l'objet en HTML
     * @return string
     */
    public function __toString()
    {
        $xtsd = self::$XTSD;
        $xtsite = self::$XTSITE;
        $xtcore = self::$XTCORE_URL;

        $xtpage = implode('::', array_map(function ($pageName) {
            return Str::toAscii($pageName, [], self::$XTJOIN_CHAR);
        }, $this->xtPage));

        $xtn2 = $this->xtn2;

        $script = <<<EOF
<script>
<!--
xtnv = document;
xtsd = "$xtsd";
xtsite = "$xtsite";
xtn2 = "$xtn2";
xtpage = "$xtpage";
xtdi = "";
xt_multc = "";	   //all the xi indicators (like "&x1=...&x2=....&x3=...")
xt_an = "";        //user ID
xt_ac = "";        //category ID
//do not modify below
if (window.xtparam!=null){window.xtparam+="&ac="+xt_ac+"&an="+xt_an+xt_multc;}
else{window.xtparam="&ac="+xt_ac+"&an="+xt_an+xt_multc;};
//-->
</script>
<script src="$xtcore"></script>
<noscript>
<img width="1" height="1" alt="" src="$xtsd.xiti.com/hit.xiti?s=$xtsite&s2=$xtn2&p=$xtpage&di=&an=&ac=" >
</noscript>
EOF;

        return $script;
    }
}
