<?php

namespace Move\Filter;

use PHPUnit\Framework\TestCase;

/**
 * Class FilterAwareTraitTest
 * @package Move\Filter
 */
class FilterAwareTraitTest extends TestCase
{
    /**
     * @covers FilterAwareTrait::setFilter
     */
    public function testSetFilter()
    {
        /** @var FilterAwareInterface $instance */
        $instance = $this->getMockForTrait(FilterAwareTrait::class);

        /** @var Filter $filter */
        $filter = $this
            ->getMockBuilder(Filter::class)
            ->getMock();

        $this->assertEquals(
            $instance,
            $instance->setFilter($filter)
        );
    }

    /**
     * @depends testSetFilter
     * @covers FilterAwareTrait::getFilter
     */
    public function testGetFilter()
    {
        /** @var FilterAwareInterface $instance */
        $instance = $this->getMockForTrait(FilterAwareTrait::class);

        /** @var Filter $filter */
        $filter = $this
            ->getMockBuilder(Filter::class)
            ->getMock();

        $instance->setFilter($filter);
        $this->assertEquals($filter, $instance->getFilter());
    }

    /**
     * @depends testSetFilter
     * @covers FilterAwareTrait::processFilter
     */
    public function testProcessFilter()
    {
        /** @var FilterAwareInterface $instance */
        $instance = $this->getMockForTrait(FilterAwareTrait::class);

        /** @var Filter|\PHPUnit_Framework_MockObject_MockObject $filter */
        $filter = $this
            ->getMockBuilder(Filter::class)
            ->getMock();

        $field = 'field';
        $data = [$field => 'test data'];

        // test 1: the filter is not configured yet
        $result = $instance->processFilter($data, $field);
        $this->assertEquals($data, $result);

        // configure the filter
        $expectedResult = 'dummy result';
        $filter
            ->expects($this->any())
            ->method('process')
            ->willReturn($expectedResult);

        $instance->setFilter($filter);

        // test 2: the filter is configured
        $result = $instance->processFilter($data, $field);
        $this->assertEquals($expectedResult, $result);
    }

    /**
     * @depends testProcessFilter
     * @covers FilterAwareTrait::processUpdateFilter
     */
    public function testProcessUpdateFilter()
    {
        /** @var FilterAwareInterface $instance */
        $instance = $this->getMockForTrait(FilterAwareTrait::class);
        $formData = ['field' => 'value'];
        $inject = [
            'field' => 'override value',
            'newField' => 'new value'
        ];

        $expected = array_merge($formData, $inject);

        $updated = $instance->processUpdateFilter($formData, $inject);
        $this->assertEquals($expected, $updated);
    }
}
