<?php

namespace Move\Providers;

use League\Container\Container;
use Monolog\Formatter\FormatterInterface;
use Monolog\Formatter\JsonFormatter;
use Monolog\Handler\HandlerInterface;
use Monolog\Logger;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;

/**
 * Class LoggerProviderTest
 * @package Move\Services
 */
class LoggerProviderTest extends TestCase
{
    /**
     * @covers LoggerProvider::__construct
     */
    public function testConstruct()
    {
        $appName = 'appName';
        $provider = new LoggerProvider($appName);
        $this->assertInstanceOf(
            LoggerProvider::class,
            $provider
        );

        return $provider;
    }

    /**
     * @depends testConstruct
     * @covers LoggerProvider::setLoggerLevel
     * @param LoggerProvider $instance
     * @return LoggerProvider
     */
    public function testSetLoggerLevel(LoggerProvider $instance)
    {
        $expected = $instance->setLoggerLevel(Logger::INFO);
        $this->assertSame($expected, $instance);
        return $instance;
    }

    /**
     * @depends testConstruct
     * @param LoggerProvider $provider
     * @return LoggerProvider
     */
    public function testSetLineFormatter(LoggerProvider $provider)
    {
        /** @var FormatterInterface|\PHPUnit_Framework_MockObject_MockObject $container */
        $formatter = $this
            ->getMockBuilder(JsonFormatter::class)
            ->getMock();
        $result = $provider->setLineFormatter($formatter);

        $this->assertSame($provider, $result);

        return $provider;
    }

    /**
     * @depends testConstruct
     * @param LoggerProvider $provider
     * @return LoggerProvider
     */
    public function testPushHandler(LoggerProvider $provider)
    {
        /** @var HandlerInterface|\PHPUnit_Framework_MockObject_MockObject $container */
        $handler = $this
            ->getMockBuilder(HandlerInterface::class)
            ->getMock();
        $result = $provider->pushHandler($handler);

        $this->assertSame($provider, $result);

        return $provider;
    }

    /**
     * @depends testSetLoggerLevel
     * @param LoggerProvider $provider
     * @covers LoggerProvider::register
     * @return LoggerProvider
     */
    public function testRegister(LoggerProvider $provider)
    {
        $container = new Container;
        $container->addServiceProvider($provider);

        $logger = $container->get(LoggerInterface::class);
        $logger2 = $container->get(LoggerInterface::class);

        $this->assertNotNull($logger);
        $this->assertNotNull($logger2);

        $this->assertSame($logger, $logger2);

        return $provider;
    }

    /**
     * @depends testRegister
     * @param LoggerProvider $provider
     * @covers LoggerProvider::boot
     */
    public function testBoot(LoggerProvider $provider)
    {
        $provider->boot();
        $this->assertTrue(true);
    }
}
