<?php

namespace Move\Restful;

use Move\Http\Client\HttpClientInterface;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class AbstractRestfulClientTest
 * @package Move\Restful
 */
class AbstractRestfulClientTest extends TestCase
{
    /** @var HttpClientInterface $httpClient */
    protected static $httpClient;

    protected function setUp()
    {
        self::$httpClient = self::$httpClient ?: $this
            ->getMockBuilder(HttpClientInterface::class)
            ->getMock();
    }

    /**
     * @covers AbstractRestfulClient
     * @return AbstractRestfulClient|\PHPUnit_Framework_MockObject_MockObject
     */
    public function testConstruct()
    {


        $instance = $this
            ->getMockBuilder(AbstractRestfulClient::class)
            ->setConstructorArgs([self::$httpClient])
            ->getMockForAbstractClass();

        $instance->expects($this->any())
            ->method('callbackIterator')
            ->willReturn([]);

        $this->assertInstanceOf(AbstractRestfulClient::class, $instance);

        return $instance;
    }

    /**
     * @covers AbstractRestfulClient::getTransformer
     * @depends testConstruct
     * @param AbstractRestfulClient $instance
     */
    public function testGetTransformer(AbstractRestfulClient $instance)
    {
        $this->assertNotEquals(null, $instance->getTransformer());
    }

    /**
     * @covers AbstractRestfulClient::getClient()
     * @depends testConstruct
     * @param AbstractRestfulClient $instance
     */
    public function testGetClient(AbstractRestfulClient $instance)
    {
        $client = $instance->getClient();
        $this->assertEquals(self::$httpClient, $client);
    }

    /**
     * @covers AbstractRestfulClient::setUpdatePolicy
     * @depends testConstruct
     * @param AbstractRestfulClient $instance
     */
    public function testSetUpdatePolicy(AbstractRestfulClient $instance)
    {
        $instance->setUpdatePolicy(AbstractRestfulClient::UPDATE_EXCEPT_NULL);
        $currentUpdatePolicy = Reflection::getValue($instance, 'updatePolicy');
        $this->assertEquals(AbstractRestfulClient::UPDATE_EXCEPT_NULL, $currentUpdatePolicy);
    }

    /**
     * @covers AbstractRestfulClient::setCreatePolicy
     * @depends testConstruct
     * @param AbstractRestfulClient $instance
     */
    public function testSetCreatePolicy(AbstractRestfulClient $instance)
    {
        $instance->setUpdatePolicy(AbstractRestfulClient::CREATE_EXCEPT_NULL);
        $currentCreatePolicy = Reflection::getValue($instance, 'createPolicy');
        $this->assertEquals(AbstractRestfulClient::CREATE_EXCEPT_NULL, $currentCreatePolicy);
    }

}
