<?php

namespace Cms\Client\AddressBook;

use Cms\Client\ClientIndexQueryBuilder;
use Cms\Model\AddressBook\Address\AddressCategoryState;

/**
 * Class AddressBookAddressCategoryClientQueryBuilder
 * @package Cms\Client\AddressBook
 */
class AddressBookAddressCategoryClientQueryBuilder extends ClientIndexQueryBuilder
{

    /**
     * @param int $parentId
     * @return $this
     */
    public function setParentId($parentId)
    {
        return $this->setFilter('parent_id', $parentId);
    }

    /**
     * @param string|AddressCategoryState $state
     * @return $this
     */
    public function setState($state)
    {
        return $this->setFilter('state', (string)$state);
    }

    /**
     * @param int $scope
     * @return $this
     */
    public function setScope($scope)
    {
        return $this->setFilter('scope_id', $scope);
    }
}
