<?php

namespace Cms\Client\Asset;

use Cms\Client\AbstractClient;
use Cms\Client\Asset\Model\ConfigRestfulModel;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Asset\Config\ConfigModel;

/**
 * Class AssetConfigClient
 * @package Cms\Client\Asset
 */
class AssetConfigClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'asset/config';

    /**
     * @param array $dataset
     * @return ConfigModel
     */
    public function handleData($dataset = [])
    {
        return (new ConfigRestfulModel())->populate($dataset);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|ConfigModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }
}
