<?php

namespace Cms\LinkResource\Provider;

use Cms\LinkResource\LinkResourceFactory;
use Cms\LinkResource\LinkResourceModel;
use Cms\LinkResource\LinkResourceType;

/**
 * Class SearchAdapterAwareTrait
 * @package Cms\LinkResource\Provider
 */
trait SearchAdapterAwareTrait
{

    /**
     * @param LinkResourceType|string $typeCode
     * @param mixed $query
     * @return LinkResourceModel[]
     * @throws \InvalidArgumentException
     * @throws \UnexpectedValueException
     */
    public function search($typeCode, $query)
    {
        $results = $this->execSearch($typeCode, $query);
        if (!\is_array($results) && !empty($results)) {
            throw new \UnexpectedValueException('results must be array');
        }
        $results = array_map(function ($ref) use ($typeCode) {
            if ($ref instanceof LinkResourceModel
                || !$this instanceof ProviderAdapterInterface
            ) {
                return $ref;
            }
            $linkResource = LinkResourceFactory::createResource($typeCode, $ref, $this->getIdentifier());
            return $linkResource;
        }, $results);
        return $results;
    }

    /**
     * @param LinkResourceType|string $typeCode
     * @param mixed $query
     * @return string[]
     */
    abstract protected function execSearch($typeCode, $query);
}
