<?php


namespace Move\Http\Route;

use League\Route\Route;
use League\Route\RouteCollection;
use League\Route\RouteGroup;

/**
 * Class LeagueRouteAdapter
 * @package Move\Http\Route
 */
class LeagueRouteAdapter extends AbstractRouterAdapter
{

    /**
     * @var RouteCollection
     */
    private $router;

    /**
     * LeagueRouteAdapter constructor.
     * @param RouteCollection $router
     */
    public function __construct(RouteCollection $router)
    {
        $this->router = $router;
    }

    /**
     * @param string $prefixUrl
     * @param array $routeList
     * @return RouteGroup
     */
    public function group($prefixUrl, array $routeList = [])
    {
        return $this->router->group($prefixUrl, [
            new LeagueRouteGroupRegistrer($routeList), 'map',
        ]);
    }

    /**
     * @param string $method
     * @param string $path
     * @param string $handler
     * @return Route
     */
    public function map($method, $path, $handler)
    {
        return $this->router->map($method, $path, $handler);
    }
}
