<?php


namespace Move\Search\Mapping;

/**
 * Class ObjectMapping
 * @package Move\Search\Mapping
 */
class ObjectMapping extends ElasticMappingProperty
{

    /** @var  bool */
    private $nested;

    /** @var  array */
    private $properties;

    /**
     * ObjectMapping constructor.
     * @param string $propName
     * @param \Move\Search\Mapping\ElasticMappingProperty[] $properties
     * @param bool $includeInAll
     */
    public function __construct(string $propName, array $properties, bool $includeInAll = true)
    {
        parent::__construct($propName, 'object', $includeInAll);
        foreach ($properties as $property) {
            $this->setProperty($property);
        }
    }

    /**
     * @param bool $nested
     * @return $this
     */
    public function isNested(bool $nested)
    {
        $this->nested = $nested;
        return $this;
    }

    /**
     * @param \Move\Search\Mapping\ElasticMappingProperty $property
     * @return $this
     */
    public function setProperty(ElasticMappingProperty $property)
    {
        $this->properties[$property->getPropName()] = $property->toArray();
        return $this;
    }

    /**
     * @return array
     */
    public function toArray() : array
    {
        $opts = parent::toArray();
        $opts['properties'] = $this->properties;
        if ($this->nested === true) {
            $opts['type'] = 'nested';
        }
        return $opts;
    }
}
