<?php

namespace Cms\Client\AddressBook;

use Cms\Client\ClientIndexQueryBuilder;
use Cms\Model\AddressBook\Trip\TripCategoryState;

/**
 * Class AddressBookTripCategoryClientQueryBuilder
 * @package Cms\Client\AddressBook
 */
class AddressBookTripCategoryClientQueryBuilder extends ClientIndexQueryBuilder
{

    /**
     * @param int $parentId
     * @return $this
     */
    public function setParentId($parentId)
    {
        return $this->setFilter('parent_id', $parentId);
    }

    /**
     * @param string|TripCategoryState $state
     * @return $this
     */
    public function setState($state)
    {
        return $this->setFilter('state', (string)$state);
    }

    /**
     * @param int $scope
     * @return $this
     */
    public function setScope($scope)
    {
        return $this->setFilter('scope_id', $scope);
    }
}
